DROP FUNCTION IF EXISTS sp_sync_so_blacklist(INT, VARCHAR);
CREATE OR REPLACE FUNCTION sp_sync_so_blacklist(INT, VARCHAR)
RETURNS TABLE (res_action INT, res_id INT) AS
$$
DECLARE
    _pSize ALIAS FOR $1;
    _pTMCM ALIAS FOR $2;
    _start_id INT := 0;
    _max_id INT := 0;
BEGIN


CREATE TEMP TABLE IF NOT EXISTS temp_table AS
SELECT 0 AS res_action, 1 AS res_id, 0 AS type_, CAST('' AS VARCHAR) AS data, 2147483647 AS expiration, 3 AS severity FROM tb_so_blacklist WHERE False;

SELECT LEAST(CAST(j.value AS INT), b.max_id), LEAST(LEAST(CAST(j.value AS INT), b.max_id) + 5000, b.max_id)
INTO _start_id, _max_id
FROM tb_journal_checkpoint AS j
INNER JOIN (SELECT coalesce(max(id), 0) AS max_id FROM tb_journal_log_blacklist) AS b
ON (section_name='udso_sync'
    AND key='Watermark');

-- Upsert tb_so_blacklist
WITH added AS (

    INSERT INTO tb_so_blacklist (type_, data, source, import_source, description, creation_time_in_utc, last_update_time_in_utc, last_modifier_display_name)

    SELECT  type_,
            data,
            1,
            1,
            NULL,
            current_timestamp at time zone 'UTC',
            current_timestamp at time zone 'UTC',
            _pTMCM
    FROM (
        SELECT a.*, b.id AS bid from (
            WITH summary AS (
                SELECT  j.type_,
                        j.data,
                        j.id,
                        j.action,
                        ROW_NUMBER() OVER (PARTITION BY j.type_, j.data
                                           ORDER BY id DESC) AS key
                FROM tb_journal_log_blacklist j
                WHERE j.id > _start_id AND j.id <= _max_id
            )
            SELECT s.*
            FROM summary AS s
            WHERE s.key = 1
        ) a
        LEFT OUTER JOIN tb_so_blacklist b
        ON (a.type_=b.type_ AND a.data=b.data AND a.action=1)
    ) b
    WHERE b.action=1


    ON CONFLICT (type_, data)
    DO UPDATE
    SET description=NULL,
        source=1,
        import_source=1,
        last_update_time_in_utc=current_timestamp at time zone 'UTC',
        last_modifier_display_name=_pTMCM
    RETURNING 1 AS res_action, id as res_id, type_, data

)
,deleted AS (
    -- delete tb_so_blacklist
    DELETE FROM tb_so_blacklist AS b
    USING (
        SELECT  type_,
                data,
                0,
                NULL,
                current_timestamp at time zone 'UTC',
                current_timestamp at time zone 'UTC',
                _pTMCM
        FROM (
            SELECT a.*, b.id AS bid from (
                WITH summary AS (
                    SELECT  j.type_,
                            j.data,
                            j.id,
                            j.action,
                            ROW_NUMBER() OVER (PARTITION BY j.type_, j.data
                                               ORDER BY id DESC) AS key
                    FROM tb_journal_log_blacklist j
                    WHERE j.id > _start_id AND j.id <= _max_id
                )
                SELECT s.*
                FROM summary AS s
                WHERE s.key = 1
            ) a
            LEFT OUTER JOIN tb_so_blacklist b
            ON (a.type_=b.type_ AND a.data=b.data AND a.action=0)
        ) b
        WHERE b.action=0
    ) AS j
    WHERE b.type_=j.type_ AND b.data = j.data -- AND b.source <> 1
    RETURNING 0 AS res_action, b.id AS res_id, b.type_, b.data
)
,push_out AS (
    DELETE FROM tb_so_blacklist b
    WHERE source=1
        AND id NOT IN (
            SELECT id
            FROM tb_so_blacklist
            WHERE source=1
            ORDER BY last_update_time_in_utc DESC, id DESC LIMIT _pSize
        )
    RETURNING 0 AS res_action, b.id AS res_id, b.type_, b.data
)
INSERT INTO temp_table (res_action, res_id, type_, data, expiration, severity)
SELECT 0 AS res_action
    , deleted.res_id AS res_id
    , deleted.type_
    , CAST(deleted.data AS VARCHAR)
    , 2147483647 AS expiration
    , 3 AS severity
FROM deleted
UNION
SELECT 0 AS res_action
    , push_out.res_id AS res_id
    , push_out.type_
    , CAST(push_out.data AS VARCHAR)
    , 2147483647 AS expiration
    , 3 AS severity
FROM push_out
UNION
SELECT 1 AS res_action
    , added.res_id
    , added.type_
    , CAST(added.data AS VARCHAR)
    , 2147483647 AS expiration
    , 3 AS severity
FROM added
;

INSERT INTO tb_so_blacklist_journal (type_, data, action, severity, expiration, last_update_time)
SELECT type_, data, t.res_action, severity, expiration, current_timestamp at time zone 'UTC'
FROM temp_table t;

RETURN QUERY SELECT a.res_action, a.res_id FROM temp_table a;
DROP TABLE temp_table;

UPDATE tb_journal_checkpoint
SET value=CAST(_max_id AS VARCHAR)
WHERE section_name='udso_sync'
    AND key='Watermark';

END;
$$ LANGUAGE plpgsql;

-- SELECT sp_sync_so_blacklist(100);
